<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <title>تاریخچه عملیات - طراحی شاداب و رنگی</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet" />
  
  <!-- فونت وزیر -->
  <link href="https://cdn.fontcdn.ir/Font/Persian/Vazir/Vazir.css" rel="stylesheet" />
  
  <style>
    body {
      font-family: 'Vazir', Tahoma, sans-serif;
      background: linear-gradient(135deg, #a8edea, #fed6e3);
      padding: 30px;
      min-height: 100vh;
      color: #444;
    }

    h2 {
      font-weight: 900;
      font-size: 3rem;
      text-align: center;
      margin-bottom: 40px;
      background: linear-gradient(90deg, #f2994a, #f2c94c, #27ae60);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      user-select: none;
      text-shadow: 0 2px 8px rgba(242, 201, 76, 0.6);
    }

    #searchInput {
      font-size: 1.2rem;
      padding: 15px 25px;
      border-radius: 50px;
      border: 2px solid #27ae60;
      box-shadow: 0 4px 15px rgba(39, 174, 96, 0.3);
      transition: all 0.3s ease;
      background-color: #fff;
      color: #333;
      width: 100%;
      max-width: 500px;
      margin: 0 auto 40px auto;
      display: block;
    }
    #searchInput:focus {
      outline: none;
      border-color: #f2994a;
      box-shadow: 0 0 15px 4px rgba(242, 153, 74, 0.7);
      background-color: #fff;
      color: #111;
    }

    .table {
      background: #ffffffdd;
      border-radius: 20px;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(242, 201, 76, 0.3);
      border: none;
      color: #444;
      font-weight: 600;
      min-width: 100%;
    }

    .table thead tr {
      background: linear-gradient(45deg, #f2994a, #f2c94c, #27ae60);
      color: #fff;
      font-size: 1.1rem;
      letter-spacing: 1.2px;
      user-select: none;
      box-shadow: 0 2px 12px rgba(39, 174, 96, 0.5);
    }

    .table thead th {
      border: none;
      vertical-align: middle;
      padding: 16px 20px;
    }

    .table tbody tr {
      transition: background 0.25s ease, transform 0.25s ease;
      cursor: default;
    }
    .table tbody tr:nth-child(odd) {
      background: #faf9f6;
    }
    .table tbody tr:nth-child(even) {
      background: #fffde7;
    }
    .table tbody tr:hover {
      background: #f2994a;
      color: white !important;
      font-weight: 700;
      transform: scale(1.03);
      box-shadow: 0 6px 20px rgba(242, 153, 74, 0.7);
      z-index: 1;
    }

    .table td {
      padding: 14px 18px;
      vertical-align: middle;
      border: none;
    }

    .pagination {
      justify-content: center;
      margin-top: 35px;
      user-select: none;
    }
    .pagination .page-item .page-link {
      color: #f2994a;
      background: #fffde7;
      border-radius: 50%;
      width: 46px;
      height: 46px;
      line-height: 46px;
      text-align: center;
      font-weight: 700;
      transition: background 0.3s, color 0.3s;
      border: none;
      box-shadow: 0 5px 15px rgba(242, 201, 76, 0.3);
    }
    .pagination .page-item.active .page-link {
      background: #27ae60;
      color: white;
      box-shadow: 0 8px 25px rgba(39, 174, 96, 0.8);
    }
    .pagination .page-item.disabled .page-link {
      opacity: 0.5;
      pointer-events: none;
    }
    .pagination .page-item .page-link:hover:not(.active) {
      background: #f2c94c;
      color: white;
      box-shadow: 0 8px 25px rgba(242, 201, 76, 0.6);
    }
  </style>
</head>
<body>

  <h2>📄 تاریخچه عملیات</h2>

  <input id="searchInput" type="text" placeholder="جستجو... (نام فرد، کار، وضعیت، شیفت، تاریخ)" />

  <div class="table-responsive shadow rounded">
    <table class="table text-center align-middle">
      <thead>
        <tr>
          <th>#</th>
          <th>وضعیت</th>
          <th>فرد</th>
          <th>کار</th>
          <th>شیفت</th>
          <th>تاریخ</th>
        </tr>
      </thead>
      <tbody id="logTableBody">
        <!-- ردیف‌ها با JS پر می‌شوند -->
      </tbody>
    </table>
  </div>

  <nav aria-label="صفحه‌بندی">
    <ul class="pagination" id="pagination"></ul>
  </nav>

<script>
  const logTableBody = document.getElementById('logTableBody');
  const pagination = document.getElementById('pagination');
  const searchInput = document.getElementById('searchInput');

  let currentPage = 1;
  let totalPages = 1;
  let currentSearch = '';

  function fetchLogs(page = 1, search = '') {
    fetch(`logs.php?page=${page}&search=${encodeURIComponent(search)}`)
      .then(res => res.json())
      .then(data => {
        currentPage = data.currentPage;
        totalPages = data.totalPages;
        currentSearch = search;

        renderTable(data.logs);
        renderPagination();
      })
      .catch(e => {
        logTableBody.innerHTML = `<tr><td colspan="6" class="text-danger">خطا در دریافت داده‌ها</td></tr>`;
        pagination.innerHTML = '';
        console.error(e);
      });
  }

  function renderTable(logs) {
    if (logs.length === 0) {
      logTableBody.innerHTML = `<tr><td colspan="6">هیچ نتیجه‌ای یافت نشد</td></tr>`;
      return;
    }
    logTableBody.innerHTML = logs.map((log, idx) => `
      <tr>
        <td>${toPersian((currentPage - 1) * 10 + idx + 1)}</td>
        <td>${escapeHtml(log.status)}</td>
        <td>${escapeHtml(log.person)}</td>
        <td>${escapeHtml(log.task)}</td>
        <td>${escapeHtml(log.shift)}</td>
        <td>${escapeHtml(log.date)}</td>
      </tr>
    `).join('');
  }

  function renderPagination() {
    let html = '';

    html += `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
      <a class="page-link" href="#" data-page="${currentPage - 1}" aria-label="قبلی">&laquo;</a>
    </li>`;

    let start = Math.max(1, currentPage - 2);
    let end = Math.min(totalPages, currentPage + 2);

    for (let i = start; i <= end; i++) {
      html += `<li class="page-item ${i === currentPage ? 'active' : ''}">
        <a class="page-link" href="#" data-page="${i}">${toPersian(i)}</a>
      </li>`;
    }

    html += `<li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
      <a class="page-link" href="#" data-page="${currentPage + 1}" aria-label="بعدی">&raquo;</a>
    </li>`;

    pagination.innerHTML = html;

    pagination.querySelectorAll('a.page-link').forEach(a => {
      a.addEventListener('click', e => {
        e.preventDefault();
        const page = parseInt(a.getAttribute('data-page'));
        if (page >= 1 && page <= totalPages && page !== currentPage) {
          fetchLogs(page, currentSearch);
          window.scrollTo({top:0, behavior:'smooth'});
        }
      });
    });
  }

  function toPersian(num) {
    const en = ['0','1','2','3','4','5','6','7','8','9'];
    const fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    return num.toString().split('').map(x => {
      const index = en.indexOf(x);
      return index >= 0 ? fa[index] : x;
    }).join('');
  }

  function escapeHtml(text) {
    if (!text) return '';
    return text.replace(/[&<>"'`=\/]/g, s => ({
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#39;',
      '`': '&#96;',
      '=': '&#61;',
      '/': '&#47;'
    })[s]);
  }

  fetchLogs();

  let searchTimeout = null;
  searchInput.addEventListener('input', () => {
    clearTimeout(searchTimeout);
    searchTimeout = setTimeout(() => {
      fetchLogs(1, searchInput.value.trim());
    }, 400);
  });
</script>

</body>
</html>
