<?php
$dataFile = __DIR__ . '/data/people.json';
$people = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];

// حذف تکراری‌ها براساس id
$uniquePeople = [];
foreach ($people as $person) {
    $uniquePeople[$person['id']] = $person;
}
$people = array_values($uniquePeople);

// افزودن فرد جدید
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    if ($name !== '') {
        $ids = array_column($people, 'id');
        $newId = $ids ? max($ids) + 1 : 1;
        $people[] = ['id' => $newId, 'name' => $name];
        file_put_contents($dataFile, json_encode($people, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
}

// حذف فرد
if (isset($_GET['delete'])) {
    $deleteId = (int)$_GET['delete'];
    $people = array_filter($people, fn($p) => $p['id'] !== $deleteId);
    file_put_contents($dataFile, json_encode(array_values($people), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// ویرایش فرد
if (isset($_POST['edit'])) {
    $editId = (int)$_POST['id'];
    $newName = trim($_POST['name']);
    foreach ($people as &$p) {
        if ($p['id'] === $editId) {
            $p['name'] = $newName;
            break;
        }
    }
    file_put_contents($dataFile, json_encode($people, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <div class="d-flex justify-content-start mb-3">
  <a href="index.php" class="btn btn-outline-secondary">🔙 بازگشت به صفحه اصلی</a>
</div>

  <title>مدیریت افراد</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="container py-4" style="direction: rtl; font-family: Tahoma">
  <h2 class="mb-4">📋 مدیریت افراد</h2>

  <form method="post" class="row g-2 mb-3">
    <div class="col-md-8">
      <input type="text" name="name" class="form-control" placeholder="نام فرد جدید" required>
    </div>
    <div class="col-md-4">
      <button type="submit" name="add" class="btn btn-success w-100">➕ افزودن</button>
    </div>
  </form>

  <table class="table table-bordered table-striped">
    <thead class="table-dark">
      <tr>
        <th>آی‌دی</th>
        <th>نام</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($people as $person): ?>
        <tr>
          <td><?= $person['id'] ?></td>
          <td>
            <?php if (isset($_GET['edit']) && $_GET['edit'] == $person['id']): ?>
              <form method="post" class="d-flex">
                <input type="hidden" name="id" value="<?= $person['id'] ?>">
                <input type="text" name="name" class="form-control me-2" value="<?= htmlspecialchars($person['name']) ?>">
                <button type="submit" name="edit" class="btn btn-primary">✔️</button>
              </form>
            <?php else: ?>
              <?= htmlspecialchars($person['name']) ?>
            <?php endif; ?>
          </td>
          <td>
            <a href="?edit=<?= $person['id'] ?>" class="btn btn-sm btn-warning">✏️ ویرایش</a>
            <a href="?delete=<?= $person['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('حذف شود؟')">🗑️ حذف</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
