<?php
header('Content-Type: application/json; charset=utf-8');

$dataDir = __DIR__ . "/data";
$logFile = "$dataDir/task_log.json";
$peopleFile = "$dataDir/people.json";
$tasksFile = "$dataDir/tasks.json";

$people = json_decode(@file_get_contents($peopleFile), true) ?: [];
$tasks = json_decode(@file_get_contents($tasksFile), true) ?: [];
$logs = json_decode(@file_get_contents($logFile), true) ?: [];

// تابع تبدیل تاریخ میلادی به شمسی
function gregorianToJalali($gy, $gm, $gd) {
    $g_d_m = array(0,31,59,90,120,151,181,212,243,273,304,334);
    if($gy > 1600){
        $jy=979;
        $gy-=1600;
    }else{
        $jy=0;
        $gy-=621;
    }
    $gy2 = ($gm > 2)?($gy+1):$gy;
    $days = (365*$gy) + intval(($gy2+3)/4) - intval(($gy2+99)/100) + intval(($gy2+399)/400) - 80 + $gd + $g_d_m[$gm-1];
    $jy += 33*intval($days/12053);
    $days %= 12053;
    $jy += 4*intval($days/1461);
    $days %= 1461;
    if($days > 365){
        $jy += intval(($days-1)/365);
        $days = ($days-1)%365;
    }
    if($days < 186){
        $jm = 1 + intval($days/31);
        $jd = 1 + ($days % 31);
    }else{
        $jm = 7 + intval(($days-186)/30);
        $jd = 1 + (($days-186) % 30);
    }
    return [$jy, $jm, $jd];
}

function toPersian($s) {
    $en = ['0','1','2','3','4','5','6','7','8','9'];
    $fa = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    return str_replace($en, $fa, $s);
}

function toJalali($d) {
    if (!$d) return '-';
    list($y,$m,$day) = explode('-', substr($d, 0, 10));
    $jalali = gregorianToJalali($y, $m, $day);
    return toPersian(implode('/', $jalali));
}

// دریافت پارامترهای صفحه‌بندی و جستجو
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage = 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$searchLower = mb_strtolower($search);

// فیلتر لاگ‌ها بر اساس جستجو
$filteredLogs = array_filter($logs, function($log) use ($people, $tasks, $searchLower) {
    if ($searchLower === '') return true;

    $person = '';
    foreach ($people as $p) {
        if ($p['id'] == $log['person_id']) {
            $person = $p['name'];
            break;
        }
    }
    $task = '';
    foreach ($tasks as $t) {
        if ($t['task_id'] == $log['task_id']) {
            $task = $t['title'];
            break;
        }
    }

    // تبدیل به حروف کوچک برای جستجوی بدون حساسیت به حروف
    if (
        mb_stripos(mb_strtolower($person), $searchLower) !== false ||
        mb_stripos(mb_strtolower($task), $searchLower) !== false ||
        mb_stripos(mb_strtolower($log['status'] ?? ''), $searchLower) !== false ||
        mb_stripos(mb_strtolower($log['shift'] ?? ''), $searchLower) !== false ||
        mb_stripos(toJalali($log['datetime']), $searchLower) !== false
    ) {
        return true;
    }
    return false;
});

// مرتب‌سازی معکوس (جدیدترین‌ها اول)
$filteredLogs = array_reverse($filteredLogs);

// تعداد کل داده‌ها پس از فیلتر
$total = count($filteredLogs);
$totalPages = ceil($total / $perPage);

// برش داده‌ها بر اساس صفحه فعلی
$offset = ($page - 1) * $perPage;
$pageLogs = array_slice($filteredLogs, $offset, $perPage);

// آماده‌سازی داده خروجی با اطلاعات کامل
$outputLogs = [];
foreach ($pageLogs as $log) {
    $personName = '';
    foreach ($people as $p) {
        if ($p['id'] == $log['person_id']) {
            $personName = $p['name'];
            break;
        }
    }
    $taskTitle = '';
    foreach ($tasks as $t) {
        if ($t['task_id'] == $log['task_id']) {
            $taskTitle = $t['title'];
            break;
        }
    }
    $outputLogs[] = [
        'status' => $log['status'] ?? '-',
        'person' => $personName,
        'task' => $taskTitle,
        'shift' => $log['shift'] ?? '-',
        'date' => toJalali($log['datetime']),
    ];
}

// ارسال پاسخ JSON
echo json_encode([
    'currentPage' => $page,
    'totalPages' => $totalPages,
    'totalItems' => $total,
    'logs' => $outputLogs,
]);
