<?php
session_start();
$dataDir = __DIR__ . "/data";
$assignFile = "$dataDir/assignments.json";
$logFile = "$dataDir/task_log.json";

$assignments = json_decode(file_get_contents($assignFile), true) ?: [];

if (!isset($_GET['index']) || !isset($assignments[$_GET['index']])) {
    header("Location: index.php");
    exit;
}

$index = intval($_GET['index']);
$item = $assignments[$index];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $status = $_POST['status'] ?? 'نامشخص';
    
    $logEntry = [
        'action' => 'delete',
        'status' => $status,
        'task_id' => $item['task_id'],
        'person_id' => $item['person_id'],
        'shift' => $item['shift'] ?? '-',
        'datetime' => date("Y-m-d H:i:s"),
        'by' => 'admin'
    ];
    
    $logs = file_exists($logFile) ? json_decode(file_get_contents($logFile), true) : [];
    $logs[] = $logEntry;
    file_put_contents($logFile, json_encode($logs, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    array_splice($assignments, $index, 1);
    file_put_contents($assignFile, json_encode($assignments, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- واکنش‌گرایی -->
    <title>تأیید حذف وظیفه</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Vazir', Tahoma, sans-serif;
            background: #f7f7f7;
        }
        h3 {
            font-weight: bold;
            font-size: 1.2rem;
            text-align: center;
        }
        form {
            max-width: 400px;
            margin: auto;
        }
        button, a.btn {
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>
<body class="container py-4">
    <h3 class="mb-4 text-danger">انتخاب وضعیت کنید</h3>
    <form method="post" class="text-center">
        <button name="status" value="انجام شده" class="btn btn-success btn-lg">✅ انجام شده</button>
        <button name="status" value="انجام نشده" class="btn btn-warning btn-lg">⛔ انجام نشده</button>
        <a href="index.php" class="btn btn-secondary btn-lg">بازگشت</a>
    </form>
</body>
</html>
