<?php
header('Content-Type: application/json; charset=utf-8');

function toPersianNumbers($input) {
    $englishNumbers = ['0','1','2','3','4','5','6','7','8','9'];
    $persianNumbers = ['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];
    return str_replace($englishNumbers, $persianNumbers, $input);
}

function gregorianToJalali($gy, $gm, $gd) {
    $g_d_m = array(0,31,59,90,120,151,181,212,243,273,304,334);
    if($gy > 1600){
        $jy=979;
        $gy-=1600;
    }else{
        $jy=0;
        $gy-=621;
    }
    $gy2 = ($gm > 2)?($gy+1):$gy;
    $days = (365*$gy) + intval(($gy2+3)/4) - intval(($gy2+99)/100) + intval(($gy2+399)/400) - 80 + $gd + $g_d_m[$gm-1];
    $jy += 33*intval($days/12053);
    $days %= 12053;
    $jy += 4*intval($days/1461);
    $days %= 1461;
    if($days > 365){
        $jy += intval(($days-1)/365);
        $days = ($days-1)%365;
    }
    if($days < 186){
        $jm = 1 + intval($days/31);
        $jd = 1 + ($days % 31);
    }else{
        $jm = 7 + intval(($days-186)/30);
        $jd = 1 + (($days-186) % 30);
    }
    return [$jy, $jm, $jd];
}

function toJalaliDate($gregorianDate){
    $parts = explode('-', $gregorianDate);
    if(count($parts) !== 3) return null;

    list($gy, $gm, $gd) = $parts;
    list($jy, $jm, $jd) = gregorianToJalali((int)$gy, (int)$gm, (int)$gd);
    $jalaliStr = sprintf('%04d/%02d/%02d', $jy, $jm, $jd);
    return toPersianNumbers($jalaliStr);
}

$weekdays = ['شنبه', 'یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنجشنبه', 'جمعه'];
// دقت: date('w') => 0 (یکشنبه) تا 6 (شنبه) در PHP نیست، در واقع 0 = یکشنبه نیست، 0=یکشنبه نیست، 0=یکشنبه نیست! (در واقع 0 = یکشنبه نیست، 0 = یکشنبه؟)
// در PHP: 0=یکشنبه, 1=دوشنبه, ... 6=شنبه نیست!
// اصلاح: در PHP: date('w') => 0 = یکشنبه, 6 = شنبه
// پس برای تبدیل به روز فارسی، باید این mapping را استفاده کنیم:

// mapping صحیح روزهای هفته شمسی در PHP:
$mapping = [0 => 1, 1 => 2, 2 => 3, 3 => 4, 4 => 5, 5 => 6, 6 => 0];

if(isset($_GET['date'])){
    $gDate = $_GET['date'];
    $jalaliDate = toJalaliDate($gDate);
    if(!$jalaliDate){
        echo json_encode(['error' => 'فرمت تاریخ اشتباه است']);
        exit;
    }
    $timestamp = strtotime($gDate);
    $dayOfWeek = date('w', $timestamp); // 0 = یکشنبه, 6 = شنبه
    $farsiDayName = $weekdays[$mapping[$dayOfWeek]];

    echo json_encode([
        'jalali' => $jalaliDate,
        'weekday' => $farsiDayName,
    ]);
    exit;
}

echo json_encode(['error' => 'تاریخ ارسال نشده']);
