<?php
$dataFile = __DIR__ . '/data/tasks.json';
$tasks = file_exists($dataFile) ? json_decode(file_get_contents($dataFile), true) : [];

// حذف تکراری‌ها براساس task_id
$uniqueTasks = [];
foreach ($tasks as $task) {
    $uniqueTasks[$task['task_id']] = $task;
}
$tasks = array_values($uniqueTasks);

// افزودن وظیفه جدید
if (isset($_POST['add'])) {
    $title = trim($_POST['title']);
    if ($title !== '') {
        $ids = array_column($tasks, 'task_id');
        $newId = $ids ? max($ids) + 1 : 101;
        $tasks[] = ['task_id' => $newId, 'title' => $title];
        file_put_contents($dataFile, json_encode($tasks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    }
}

// حذف وظیفه
if (isset($_GET['delete'])) {
    $deleteId = (int)$_GET['delete'];
    $tasks = array_filter($tasks, fn($t) => $t['task_id'] !== $deleteId);
    file_put_contents($dataFile, json_encode(array_values($tasks), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}

// ویرایش وظیفه
if (isset($_POST['edit'])) {
    $editId = (int)$_POST['task_id'];
    $newTitle = trim($_POST['title']);
    foreach ($tasks as &$t) {
        if ($t['task_id'] === $editId) {
            $t['title'] = $newTitle;
            break;
        }
    }
    file_put_contents($dataFile, json_encode($tasks, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>مدیریت وظایف</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="container py-4" style="direction: rtl; font-family: Tahoma">
  <h2 class="mb-4">🛠️ مدیریت وظایف</h2>

  <a href="index.php" class="btn btn-outline-secondary mb-3">🔙 بازگشت</a>

  <form method="post" class="row g-2 mb-3">
    <div class="col-md-8">
      <input type="text" name="title" class="form-control" placeholder="عنوان وظیفه جدید" required>
    </div>
    <div class="col-md-4">
      <button type="submit" name="add" class="btn btn-success w-100">➕ افزودن</button>
    </div>
  </form>

  <table class="table table-bordered table-striped">
    <thead class="table-dark">
      <tr>
        <th>کد وظیفه</th>
        <th>عنوان</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($tasks as $task): ?>
        <tr>
          <td><?= $task['task_id'] ?></td>
          <td>
            <?php if (isset($_GET['edit']) && $_GET['edit'] == $task['task_id']): ?>
              <form method="post" class="d-flex">
                <input type="hidden" name="task_id" value="<?= $task['task_id'] ?>">
                <input type="text" name="title" class="form-control me-2" value="<?= htmlspecialchars($task['title']) ?>">
                <button type="submit" name="edit" class="btn btn-primary">✔️</button>
              </form>
            <?php else: ?>
              <?= htmlspecialchars($task['title']) ?>
            <?php endif; ?>
          </td>
          <td>
            <a href="?edit=<?= $task['task_id'] ?>" class="btn btn-sm btn-warning">✏️ ویرایش</a>
            <a href="?delete=<?= $task['task_id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('حذف شود؟')">🗑️ حذف</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
