<?php
// داده‌ها
$assignmentsJson = '[ ... همان داده‌ها ... ]';
$tasksJson = '[ ... همان داده‌ها ... ]';
$peopleJson = '[ ... همان داده‌ها ... ]';

$assignments = json_decode($assignmentsJson, true);
$tasks = json_decode($tasksJson, true);
$people = json_decode($peopleJson, true);

$tasksMap = [];
foreach ($tasks as $task) {
    $tasksMap[$task['task_id']] = $task['title'];
}

$peopleMap = [];
foreach ($people as $person) {
    $peopleMap[$person['id']] = $person['name'];
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>نمایش متحرک وظایف</title>
<style>
  body {
    font-family: Tahoma, sans-serif;
    background: #f5f5f5;
    margin: 20px;
  }
  h2 {
    text-align: center;
    margin-bottom: 15px;
  }
  .marquee-wrapper {
    width: 100%;
    overflow: hidden;
    border: 1px solid #ccc;
    background: white;
    box-sizing: border-box;
    padding: 10px 0;
  }
  .marquee-content {
    display: inline-block;
    white-space: nowrap;
    will-change: transform;
  }
  .task-item {
    display: inline-block;
    margin: 0 40px;
    padding: 8px 20px;
    border-radius: 12px;
    font-size: 16px;
    font-weight: 600;
    color: white;
    user-select: none;
    cursor: default;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    transition: transform 0.3s ease;
  }
  .task-item:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
  }
  .red {
    background-color: #d9534f;
  }
  .black {
    background-color: #343a40;
  }
  .green {
    background-color: #28a745;
  }
</style>
</head>
<body>

<h2>نمایش متحرک وظایف</h2>

<div class="marquee-wrapper" aria-label="نمایش متحرک وظایف">
  <div id="marquee" class="marquee-content" aria-live="off" aria-atomic="true" aria-relevant="additions removals">
    <?php
      foreach ($assignments as $assign) {
        $title = $tasksMap[$assign['task_id']] ?? 'عنوان نامشخص';
        $person = $peopleMap[$assign['person_id']] ?? 'نامشخص';
        $colorClass = htmlspecialchars($assign['color']);
        echo '<div class="task-item ' . $colorClass . '">';
        echo htmlspecialchars($title) . ' — ' . htmlspecialchars($person) . ' (' . htmlspecialchars($assign['shift']) . ')';
        echo '</div>';
      }
    ?>
  </div>
</div>

<script>
(() => {
  const marquee = document.getElementById('marquee');
  const speed = 0.8; // سرعت پیکسل بر فریم
  let currentX = 0;

  // محتوای اولیه را چند بار تکرار کن برای نرمی بیشتر
  const repeatCount = 3;
  let originalHTML = marquee.innerHTML;
  marquee.innerHTML = originalHTML.repeat(repeatCount);

  function animate() {
    currentX -= speed;
    if (Math.abs(currentX) >= marquee.scrollWidth / repeatCount) {
      currentX = 0;
    }
    marquee.style.transform = `translateX(${currentX}px)`;
    requestAnimationFrame(animate);
  }
  animate();
})();
</script>

</body>
</html>
