<?php
date_default_timezone_set('Asia/Tehran');

// مسیر فعلی و مسیر ذخیره بکاپ
$baseDir = __DIR__;
$backupDir = $baseDir . '/backups';
if (!is_dir($backupDir)) {
    mkdir($backupDir, 0777, true);
}

$timestamp = date('Y-m-d_H-i-s');
$backupFile = "$backupDir/backup_$timestamp.zip";

$zip = new ZipArchive();
if ($zip->open($backupFile, ZipArchive::CREATE) !== TRUE) {
    die("❌ امکان ساخت فایل ZIP وجود ندارد.");
}

// تابع بازگشتی برای افزودن فایل‌ها
function addFolderToZip($folder, $zip, $basePathLength) {
    $files = scandir($folder);
    foreach ($files as $file) {
        if ($file == '.' || $file == '..') continue;
        $fullPath = $folder . '/' . $file;
        $localPath = substr($fullPath, $basePathLength + 1);
        if (is_dir($fullPath)) {
            $zip->addEmptyDir($localPath);
            addFolderToZip($fullPath, $zip, $basePathLength);
        } else {
            $zip->addFile($fullPath, $localPath);
        }
    }
}

// اضافه‌کردن کل پروژه
addFolderToZip($baseDir, $zip, strlen($baseDir));
$zip->close();

?>
<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>بکاپ‌گیری کلی</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="container py-4" style="direction: rtl; font-family: Tahoma">
  <h3 class="mb-3">✅ بکاپ با موفقیت ساخته شد</h3>
  <div class="alert alert-success">
    مسیر فایل بکاپ:
    <br>
    <code><?= htmlspecialchars($backupFile) ?></code>
  </div>
  <a href="<?= str_replace($baseDir, '', $backupFile) ?>" class="btn btn-primary">⬇️ دانلود فایل بکاپ</a>
  <a href="index.php" class="btn btn-secondary">⬅️ بازگشت</a>
</body>
</html>
