<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET');
header('Access-Control-Allow-Headers: Content-Type');

define('DATA_USERS', __DIR__ . '/data/users.json');
define('DATA_TASKS', __DIR__ . '/data/tasks.json');

if (!file_exists(__DIR__.'/data')) {
    mkdir(__DIR__.'/data', 0777, true);
}
if (!file_exists(DATA_USERS)) {
    file_put_contents(DATA_USERS, json_encode([]));
}
if (!file_exists(DATA_TASKS)) {
    file_put_contents(DATA_TASKS, json_encode([]));
}

// خواندن ورودی JSON
$input = json_decode(file_get_contents('php://input'), true);
$action = $_GET['action'] ?? '';

function loadData($file) {
    $json = file_get_contents($file);
    $data = json_decode($json, true);
    if (!is_array($data)) $data = [];
    return $data;
}

function saveData($file, $data) {
    return file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// تولید شناسه یکتا
function generateId($items) {
    $max = 0;
    foreach ($items as $item) {
        if (isset($item['id']) && $item['id'] > $max) {
            $max = $item['id'];
        }
    }
    return $max + 1;
}

// پاسخ خطا
function errorResponse($msg) {
    echo json_encode(['status' => false, 'message' => $msg]);
    exit;
}

// پاسخ موفقیت
function successResponse($data = null) {
    echo json_encode(['status' => true, 'data' => $data]);
    exit;
}

switch($action) {
    case 'get_users':
        $users = loadData(DATA_USERS);
        successResponse($users);
        break;

    case 'add_user':
        $users = loadData(DATA_USERS);
        $name = trim($input['name'] ?? '');
        if ($name === '') {
            errorResponse('نام کاربر نمی‌تواند خالی باشد.');
        }
        $id = generateId($users);
        $users[] = ['id' => $id, 'name' => $name];
        if(saveData(DATA_USERS, $users)) {
            successResponse();
        } else {
            errorResponse('خطا در ذخیره‌سازی کاربران.');
        }
        break;

    case 'edit_user':
        $users = loadData(DATA_USERS);
        $id = intval($input['id'] ?? 0);
        $name = trim($input['name'] ?? '');
        if ($id === 0 || $name === '') {
            errorResponse('شناسه یا نام کاربر معتبر نیست.');
        }
        $found = false;
        foreach ($users as &$user) {
            if ($user['id'] === $id) {
                $user['name'] = $name;
                $found = true;
                break;
            }
        }
        if (!$found) {
            errorResponse('کاربر پیدا نشد.');
        }
        if(saveData(DATA_USERS, $users)) {
            successResponse();
        } else {
            errorResponse('خطا در ذخیره‌سازی کاربران.');
        }
        break;

    case 'delete_user':
        $users = loadData(DATA_USERS);
        $tasks = loadData(DATA_TASKS);
        $id = intval($input['id'] ?? 0);
        if ($id === 0) {
            errorResponse('شناسه کاربر معتبر نیست.');
        }
        // حذف کاربر
        $users = array_filter($users, fn($u) => $u['id'] !== $id);
        // حذف وظایف مربوط به کاربر
        $tasks = array_filter($tasks, fn($t) => $t['assigned_to'] !== $id);
        if(saveData(DATA_USERS, $users) && saveData(DATA_TASKS, $tasks)) {
            successResponse();
        } else {
            errorResponse('خطا در حذف کاربر یا وظایف.');
        }
        break;

    case 'get_tasks':
        $tasks = loadData(DATA_TASKS);
        successResponse($tasks);
        break;

    case 'get_task':
        $tasks = loadData(DATA_TASKS);
        $id = intval($_GET['id'] ?? 0);
        if ($id === 0) errorResponse('شناسه وظیفه معتبر نیست.');
        foreach ($tasks as $task) {
            if ($task['id'] === $id) {
                successResponse($task);
            }
        }
        errorResponse('وظیفه پیدا نشد.');
        break;

    case 'add_task':
        $tasks = loadData(DATA_TASKS);
        $title = trim($input['title'] ?? '');
        $desc = trim($input['description'] ?? '');
        $assigned_to = intval($input['assigned_to'] ?? 0);
        $due_date = trim($input['due_date'] ?? '');
        $status = trim($input['status'] ?? 'open');

        if ($title === '') errorResponse('عنوان وظیفه نمی‌تواند خالی باشد.');
        if ($assigned_to === 0) errorResponse('مسئول وظیفه معتبر نیست.');

        $id = generateId($tasks);
        $tasks[] = [
            'id' => $id,
            'title' => $title,
            'description' => $desc,
            'assigned_to' => $assigned_to,
            'due_date' => $due_date,
            'status' => $status
        ];
        if(saveData(DATA_TASKS, $tasks)) {
            successResponse();
        } else {
            errorResponse('خطا در ذخیره‌سازی وظایف.');
        }
        break;

    case 'edit_task':
        $tasks = loadData(DATA_TASKS);
        $id = intval($input['id'] ?? 0);
        if ($id === 0) errorResponse('شناسه وظیفه معتبر نیست.');
        $title = trim($input['title'] ?? '');
        $desc = trim($input['description'] ?? '');
        $assigned_to = intval($input['assigned_to'] ?? 0);
        $due_date = trim($input['due_date'] ?? '');
        $status = trim($input['status'] ?? 'open');

        if ($title === '') errorResponse('عنوان وظیفه نمی‌تواند خالی باشد.');
        if ($assigned_to === 0) errorResponse('مسئول وظیفه معتبر نیست.');

        $found = false;
        foreach ($tasks as &$task) {
            if ($task['id'] === $id) {
                $task['title'] = $title;
                $task['description'] = $desc;
                $task['assigned_to'] = $assigned_to;
                $task['due_date'] = $due_date;
                $task['status'] = $status;
                $found = true;
                break;
            }
        }
        if (!$found) errorResponse('وظیفه پیدا نشد.');
        if(saveData(DATA_TASKS, $tasks)) {
            successResponse();
        } else {
            errorResponse('خطا در ذخیره‌سازی وظایف.');
        }
        break;

    case 'delete_task':
        $tasks = loadData(DATA_TASKS);
        $id = intval($input['id'] ?? 0);
        if ($id === 0) errorResponse('شناسه وظیفه معتبر نیست.');
        $tasks = array_filter($tasks, fn($t) => $t['id'] !== $id);
        if(saveData(DATA_TASKS, $tasks)) {
            successResponse();
        } else {
            errorResponse('خطا در حذف وظیفه.');
        }
        break;

    default:
        errorResponse('عملیات نامشخص یا غیرمجاز است.');
}
